<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            // Invoice Settings (company_name already exists)
            $table->string('invoice_header_text')->default('INVOICE');
            $table->text('invoice_footer_text')->nullable();
            $table->string('invoice_template')->default('default');
            
            // WhatsApp Settings
            $table->boolean('whatsapp_enabled')->default(true);
            $table->boolean('auto_send_whatsapp')->default(false);
            $table->text('invoice_message_template')->nullable();
            
            // Invoice Options
            $table->boolean('include_company_logo')->default(true);
            $table->boolean('include_qr_code')->default(false);
            
            // Terms & Conditions
            $table->text('invoice_terms_conditions')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            $table->dropColumn([
                'invoice_header_text',
                'invoice_footer_text',
                'invoice_template',
                'whatsapp_enabled',
                'auto_send_whatsapp',
                'invoice_message_template',
                'include_company_logo',
                'include_qr_code',
                'invoice_terms_conditions'
            ]);
        });
    }
};
